/*******************************************************************
/*  CommonUnit.h
/*  Author: Vadim Berman
/*
/*  Description:
/*  declaration of auxiliary structures handlers and most
/*  non-member service functions
/*
/*  The contents of this file are subject to the Brainiac Public License.
/*  Version 1.0 (the "License"); you may not use this file except in
/*  compliance with the License. You may obtain a copy of the License at
/*  http://www.twilightminds.com
/*
/*  Software distributed under the License is distributed on an "AS IS"
/*  basis WITHOUT WARRANTY OF ANY KIND, either express or implied. See
/*  the License for the specific language governing rights and limitations
/*  under the License.
/*
/*  Copyright (C) 1999 Twilight Minds. All rights reserved.
/********************************************************************/

#ifndef COMMONUNIT_H
#define COMMONUNIT_H
//-----------------------------------------------------------------------
#include <windows.h>
#include <winuser.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include "bbe_def.h"

//--------------------------------------------------------------
extern char Msg1[200];

//--------------------------------------------------------------
EXPO int BBECALL Random(int LoLimit, int HiLimit);

//--------------------------------------------------------------
struct _Attitude {
  ID person_id;
  percentage Real;
  percentage Seemed;
  struct _Attitude *RSon, *LSon;
} ;

typedef struct _Attitude   Attitude;

typedef ID AlignmentType ;


typedef struct _Core {
  AlignmentType alType;
  percentage Wickedness;
  percentage Anarchy;

  //secondary variables
  percentage InitialAttitude; //neutral, uninfluenced starting personal attitude
  percentage AttitudeChangeUnit;
  percentage SuddenChange;

  percentage   LieProbability;
  //Impression values - [1] means "true social"; [0] -
  // "seemed social"
  percentage Meanness[2], Wealth[2], Beauty;
  percentage Foreignness;
  percentage Intelligence[2], Courage;
  short UserDefined[3];
  ID attId;
  Attitude *attPersonal; //binary tree of personal attitudes
  _Core *LastAccessedBy;
  unsigned char CurrentEnvironment;
    // nature of actions aimed at this person
  ID LastTargettedInAction, LastCommittedAction;
  BOOL Dead;
} Core;

typedef struct {
    ID ItemID;
    ID Owner;
	percentage Wickedness;
	percentage Anarchy;
	percentage Meanness, Foreignness, Wealth, Beauty, Personality;
	percentage Influence;	//0 to 100 - percentage of influence on the
    		//overall Impression
    BOOL CanBeDivided;
    unsigned short UserDefined[3];
} ItemScores;

typedef ItemScores* ItemPtr;
typedef ItemPtr*    ItemPtrArr;
//-----------------------------------------------------------------------
typedef struct {
	ID Itself;
    percentage Importance; //actual importance is Strategy property only
} Goal;

struct _GoalDefNode {
	Goal goal;
    char Descr[GOAL_DESC_LEN];
	Core LoReqs, HiReqs; //that's for the "autorun" feature
        //and criteria
    unsigned char CompType,AttDir,IdFlag1;
    ID IdFlag2;
    ID UserDefAttID;
    ID AttRefAct;
    ID IncGoalID;
	struct _GoalDefNode *next;
};
typedef struct _GoalDefNode* GoalDefNodeP;

struct _MindDefNode {
    ID MindID;
    char Descr[MIND_DESC_LEN];
    percentage LWick,HWick,LAnar,HAnar;
    percentage InitialAttitude;
    //neutral, uninfluenced starting personal attitude
    percentage AttitudeChangeUnit;
    percentage SuddenChange;
    percentage AbsMeanness, Meanness, AbsWealth, Wealth,
        AbsBeauty, Beauty, AbsIntelligence, Intelligence;
    percentage Foreignness;
    percentage ItemMeanness, ItemBeauty, ItemWealth, ItemIntelligence;
    struct _MindDefNode *next;
};
typedef struct _MindDefNode* MindDefNodeP;

//-----------------------------------------------------------------------
int BBECALL SumAndMax(percentage*, unsigned int, percentage&);
EXPO void BBECALL Stop(char *);
EXPO percentage BBECALL GetAttitude(ID , Attitude *, BOOL = TRUE);
EXPO BOOL BBECALL AddAttitude(ID , percentage , Attitude **);
BOOL BBECALL AddBothAttitudes(ID , percentage , percentage , Attitude **);
EXPO BOOL BBECALL ModifyAttitude(ID , short , Attitude *, unsigned char = 2);
EXPO BOOL BBECALL UpdateAttitude(ID , percentage ,//set or add
	Attitude **, unsigned char = 2);
void BBECALL DelAttitude(ID , Attitude **);
EXPO void BBECALL DelAttitudeTree(Attitude **);
EXPO Attitude * BBECALL CopyAttitudeTree(Attitude*);
EXPO void BBECALL Attitudes2String(Attitude *, char *);
EXPO unsigned short BBECALL DumpAttitudeTree2Buffer(Attitude *, BYTE *);
EXPO Attitude * BBECALL RestoreAttitudeTreeFromBuffer(BYTE *,
    unsigned short );
Attitude* BBECALL GetAttitudeNode(ID , Attitude *);
percentage BBECALL ForDiff(percentage, percentage);
BOOL BBECALL CheckCriteria(GoalDefNodeP , Core *, Core * = NULL,
        percentage * = NULL);
BOOL BBECALL CheckItemCriteria(GoalDefNodeP,ItemScores*,ItemScores* = NULL);
unsigned short BBECALL DecodeShort(unsigned short);
void BBECALL SetCoreDefaults(Core& );
void BBECALL CustomNew();
EXPO void BBECALL APIError();
char *BBECALL GetAttitudeDesc(percentage);
percentage BBECALL OutOfLimits(percentage,percentage);
percentage BBECALL ScoreVal(unsigned char, Core, unsigned char = 1);
percentage BBECALL ItemPersonalEval(Core &, ItemScores& );
void BBECALL PostError(long);
EXPO char *BBECALL LastBEError();
EXPO long BBECALL LastBEErrorCode();
EXPO unsigned short BBECALL BSFillSaveBuffer(Core , BYTE *);//saving basic scores

EXPO Core *BBECALL FindBSAddress(ID, Core **,unsigned short);
EXPO void BBECALL BSRestoreFromBufferStep1(BYTE *, unsigned short,
        Core* );
EXPO void BBECALL BSRestoreFromBufferStep2(Core* ,
        Core **, unsigned short );
EXPO ItemScores *BBECALL FindItemAddress(ID ,ID ,
            unsigned short ,ItemPtrArr* ,
            unsigned short* );
const char* BBECALL twGetModuleDirectory();

#endif

